import sys
sys.path.append('../Common')
sys.path.append('../Devices')
from EPS1000 import EPS1000


eps = EPS1000('192.168.1.102') # connect by LAN
#eps = EPS1000('USB') # connect by USB

fw = eps.getfirmware()
print('firmware version is ' + fw)

sn = eps.getserialnumber()
print(f'serial number is {sn}')

print('number of wlen bands:', eps.getnrofwlenbands())

freq = 190
eps.setoptfrequency(freq)
print(f'Frequency is now {eps.getoptfrequency()} THz')

eps.setdistrpeaked(10000) # set 10 krad/s Peaked distribution
#eps.setdistrpeakedplus(12000000) # set 12 Mrad/s Peaked+ distribution
#eps.setdistrrayleigh(1000000) # set 1 Mrad/s Rayleigh distribution
#eps.setdistrdepol(16000000) # set 16 Mrad/s Depolarizer distribution


eps.close()
