from time import sleep
import ftd2xx as ftd
from ctypes import create_string_buffer
import numpy as np
import struct

class NovoptelUSB2():

   
    # Parameters
    baudrate = 230400
    d = None
    
    def __init__(self):
        
        self.isConnected = False
        self.d = None
    
        # list all connected ftdi devices
        dlist=ftd.listDevices(2)
        if len(dlist)>0:
            counter = 0
            for dev in dlist[:]:
                if (len(dev)==0):
                    print("    " + str(counter) + ": " + "<blocked>")
                else:
                    print("    " + str(counter) + ": " + dev.decode('UTF-8'))
                counter = counter + 1
            print("    Select Instrument (-1 to Quit):")
            devicenr = int(input())
            if devicenr>=0:
                self.connect(devicenr)
        else:
             print("    No Instrument found")
        return
        
        
        
    def connect( self, devicenr):
        
        self.d = ftd.open(devicenr)    # Open selected FTDI device
        self.d.setBaudRate(self.baudrate)
        self.d.setDataCharacteristics(8, 0, 0)
        self.d.clrRts()
        #sleep(1)
        self.d.setRts()
        self.d.setDtr()
        self.d.setLatencyTimer(2)
        self.d.purge()
        #sleep(1)
        self.isConnected = True
        print( "Connected." )
        return
        
    def close( self ):
        self.d.close()
        self.isConnected = False
        print( "Closed." )
        return
        
        
    def write(self, addr, data):
        sleep(0.01)
        self.d.purge() # clear buffers
        txstring = 'W' + '{:03X}'.format(addr) + '{:04X}'.format(data) + chr(13)
        tx = create_string_buffer(txstring.encode('utf-8'), 9)
        self.d.write(tx)
        #sleep(0.01)
        return
        
    def read(self, addr):
    
        sleep(0.01)    
        self.d.purge() # clear buffers

        # send request command
        txstring = 'R' + '{:03X}'.format(addr) + '0000' + chr(13)
        #print(txstring)
        tx = create_string_buffer(txstring.encode('utf-8'), 9)
        self.d.write(tx)
        
        # wait for RX
        bytesavailable=0
        tries=0
        while bytesavailable<5 and tries<1000:
            bytesavailable=self.d.getQueueStatus()
            tries += 1
            #sleep(0.001)
        
        # get RX
        res=self.d.read(bytesavailable)
        
        #print(len(res))
        #print(type(res))
        #for ires in res[:]:
        #        print(ires)
        #print(tries)
        #print(res.decode("utf-8"))
        #print(int(res.decode("utf-8"),16))
        
        
        # return RX as integer
        if bytesavailable>4:
            val = int(res.decode("utf-8"),16)
        else:
            val = -1     
        return val
        
        
    def readsdram(self, startaddr: int, numaddr: int):
            
        buffer_bytes = 2**16
        buffer_addr = buffer_bytes/8
        
        addrtransferred = 0
        curaddr = startaddr
        
        res = np.empty((0, 4))
        while addrtransferred<numaddr:
            curnumaddr = int(min(buffer_addr, numaddr-addrtransferred))
            
            data = self.readsdram_int(curaddr, curnumaddr)
            res = np.concatenate((res, data[:int(curnumaddr),:]), axis=0)
            
            curaddr = curaddr + curnumaddr
            addrtransferred = addrtransferred + curnumaddr
        
        return res
        
    def readsdram_int(self, startaddr: int, numaddr: int):
        self.write(512+105, int(startaddr) & 0xFFFF)
        self.write(512+106, int(startaddr) >> 16)
        self.write(512+107, numaddr)
        self.write(512+104, 39293) # hsusb reset trigger so that next transfer starts from "startaddr"; also resets the fifo_crc
        
        bytesavailable=0
        tries=0
        while bytesavailable<8*numaddr and tries<1000:
            sleep(0.001)
            tries = tries + 1
            bytesavailable=self.d.getQueueStatus()
        
        if bytesavailable>=8*numaddr:
            recvbytes = self.d.read(bytesavailable)
            ansBuf16 = struct.unpack('H'*int(bytesavailable/2), recvbytes)
            arrint16 = np.array(list(ansBuf16))
            rows = bytesavailable // 8
            res = arrint16[0:rows * 4].reshape(rows, 4)
            
        else:
            print("*** Timeout during readsdram_int.")
            return 0
        
        
        
        
        return res