import sys
import PyD3XX
import numpy as np
#from array import array
#import struct


class NovoptelPyD3XX():

    # Parameters
    DEVNO = None
    
    def __init__( self ):

        PyD3XX.SetPrintLevel(PyD3XX.PRINT_NONE) # Make PyD3XX not print anything.

        Status, DeviceCount = PyD3XX.FT_CreateDeviceInfoList() # Create a device info list.

        if Status != PyD3XX.FT_OK:
            print(PyD3XX.FT_STATUS_STR[Status] + " | FAILED TO CREATE DEVICE INFO LIST: ABORTING")
            return None

        print(str(DeviceCount) + " Devices detected.")

        if (DeviceCount == 0):
            print("NO DEVICES DETECTED: ABORTING")
            return None

        for counter in range(DeviceCount):
            #print(counter)
            
            Status, Device = PyD3XX.FT_GetDeviceInfoDetail(counter) # Get info of a device at index 0.

            if Status != PyD3XX.FT_OK:
                print(PyD3XX.FT_STATUS_STR[Status] + " | WARNING: FAILED TO GET INFO FOR DEVICE 0")

            print("    " + str(counter+1) + ": " +  Device.Description)

        print("    Select Instrument (0 to Quit):")
        select = int(input())-1
        if select<0:
            return None


        Status, Device = PyD3XX.FT_GetDeviceInfoDetail(select) # Get info of a device at index 0.
        
        if Status != PyD3XX.FT_OK:
            print(PyD3XX.FT_STATUS_STR[Status] + " | WARNING: FAILED TO GET INFO FOR DEVICE 0")
    
        Status = PyD3XX.FT_Create(select, PyD3XX.FT_OPEN_BY_INDEX, Device) # Open the device we're using.

        if Status != PyD3XX.FT_OK:
            print(PyD3XX.FT_STATUS_STR[Status] + " | FAILED TO OPEN DEVICE: ABORTING")
            return None
        else:
            print( "Connected." )
            self.DEVNO = Device
        return
    

    def close(self):

        PyD3XX.FT_Close(self.DEVNO)

        print( "Closed." )

        self.DEVNO = None

        return


    def crc16( self, crc, data):
        for x in data:
            crc = ((crc<<1) | (crc>>15)) & 0xFFFF
            crc ^= x
        return crc
    

    def read( self, addr ):
        
        Pipes = {}
        for i in range(2): # Get in and out pipes for channel 1
            Status, Pipes[i] = PyD3XX.FT_GetPipeInformation(self.DEVNO, 1, i)
            
        #reqBuf16 = array('H',[82,addr,0])
        reqBuf16 = np.array([82, addr, 0], dtype=np.uint16)
        crc = self.crc16(0xFFFF, reqBuf16)
        #print("crc = " + str(crc))
        reqBuf16 = np.append(reqBuf16, np.uint16(crc))
        #print(reqBuf16)
        #sendbytes = bytes(reqBuf16)
        
        #self.d.writePipe(0x02, sendbytes, 8)
        WriteBuffer = PyD3XX.FT_Buffer.from_bytes(reqBuf16.tobytes())
        if (PyD3XX.Platform=="linux") or (PyD3XX.Platform=="darwin"):
            Status, BytesWrote = PyD3XX.FT_WritePipe(self.DEVNO, int("0x02", 16), WriteBuffer, 8, 0)
        else:
            Status, BytesWrote = PyD3XX.FT_WritePipe(self.DEVNO, Pipes[0], WriteBuffer, 8, PyD3XX.NULL)
        
                
        #recvbytes=bytes(8)
        #self.d.readPipe(0x82, recvbytes, 8)
        if (PyD3XX.Platform=="linux") or (PyD3XX.Platform=="darwin"):
            Status, ReadBuffer, BytesRead = PyD3XX.FT_ReadPipe(self.DEVNO, int("0x82", 16), 8, 0)
        else:
            Status, ReadBuffer, BytesRead = PyD3XX.FT_ReadPipe(self.DEVNO, Pipes[1], 8, PyD3XX.NULL)

        #recvbytes = ReadBuffer.Value()
        #ansBuf16 = struct.unpack('H'*int(len(recvbytes)/2), recvbytes)

        #ansBuf16 = struct.unpack('H'*int(BytesRead/2), ReadBuffer)
        #print(str(ansBuf16))

        ansBuf16 = np.frombuffer(ReadBuffer.Value(), np.uint16)
        
        # CRC check
        #crc = self.crc16(crc, array('H',[ansBuf16[2]]))
        crc = self.crc16(crc, np.array([ansBuf16[2]]))
        #print("crc = " + str(crc))
        if crc!=ansBuf16[1]:
            print("*** CRC ERROR during ReadUSB!")
            return 0 
        else:
            return int(ansBuf16[2])
             
        
    def write( self, addr, data ):
        
        Pipes = {}
        for i in range(2): # Get in and out pipes for channel 1
            Status, Pipes[i] = PyD3XX.FT_GetPipeInformation(self.DEVNO, 1, i)
            
        #reqBuf16 = array('H',[87,addr,data])
        #crc = self.crc16(0xFFFF, reqBuf16)
        #reqBuf16.append(crc)
        #sendbytes = bytes(reqBuf16)

        reqBuf16 = np.array([87, addr, data], dtype=np.uint16)
        crc = self.crc16(0xFFFF, reqBuf16)
        reqBuf16 = np.append(reqBuf16, np.uint16(crc))
        #sendbytes = 

        
        
        #print(sendbytes)

        #self.d.writePipe(0x02, sendbytes, 8)
        WriteBuffer = PyD3XX.FT_Buffer.from_bytes(reqBuf16.tobytes())
        if (PyD3XX.Platform=="linux") or (PyD3XX.Platform=="darwin"):
            Status, BytesWrote = PyD3XX.FT_WritePipe(self.DEVNO, int("0x02", 16), WriteBuffer, 8, 0)
        else:
            Status, BytesWrote = PyD3XX.FT_WritePipe(self.DEVNO, Pipes[0], WriteBuffer, 8, PyD3XX.NULL)
        
        #sleep(0.1)
        
        #recvbytes=bytes(8)
        #self.d.readPipe(0x82, recvbytes, 8)
        if (PyD3XX.Platform=="linux") or (PyD3XX.Platform=="darwin"):
            Status, ReadBuffer, BytesRead = PyD3XX.FT_ReadPipe(self.DEVNO, int("0x82", 16), 8, 0)
        else:
            Status, ReadBuffer, BytesRead = PyD3XX.FT_ReadPipe(self.DEVNO, Pipes[1], 8, PyD3XX.NULL)
        #recvbytes = ReadBuffer.Value()
        #ansBuf16 = struct.unpack('H'*int(len(recvbytes)/2), recvbytes)
        ansBuf16 = np.frombuffer(ReadBuffer.Value(), np.uint16)
        #print(ansBuf16[0])
        if ansBuf16[0]!=52428:
            print("*** CRC ERROR during WriteUSB!")
            return 0 
        else:
            return 1

    def setsdramstream(self):
        
        Pipes = {}
        for i in range(2): # Get in and out pipes for channel 1
            Status, Pipes[i] = PyD3XX.FT_GetPipeInformation(self.DEVNO, 1, i)
            
        reqBuf16 = np.array([83, 0, 0], dtype=np.uint16) # 'S'
        crc = self.crc16(0xFFFF, reqBuf16)
        reqBuf16 = np.append(reqBuf16, np.uint16(crc))

        #self.d.writePipe(0x02, sendbytes, 8)
        WriteBuffer = PyD3XX.FT_Buffer.from_bytes(reqBuf16.tobytes())

        if (PyD3XX.Platform=="linux") or (PyD3XX.Platform=="darwin"):
            Status, BytesWrote = PyD3XX.FT_WritePipe(self.DEVNO, int("0x02", 16), WriteBuffer, 8, 0)
        else:
            Status, BytesWrote = PyD3XX.FT_WritePipe(self.DEVNO, Pipes[0], WriteBuffer, 8, PyD3XX.NULL)
        
        return
    
    def readstream_raw(self, packetsinthissequence: int):
        Pipes = {}
        for i in range(2): # Get in and out pipes for channel 1
            Status, Pipes[i] = PyD3XX.FT_GetPipeInformation(self.DEVNO, 1, i)
        self.setsdramstream()
        BytesReq = (packetsinthissequence)*8
        if (PyD3XX.Platform=="linux") or (PyD3XX.Platform=="darwin"):
            Status, ReadBuffer, BytesRead = PyD3XX.FT_ReadPipe(self.DEVNO, int("0x82", 16), int(BytesReq), 0)
        else:
            Status, ReadBuffer, BytesRead = PyD3XX.FT_ReadPipe(self.DEVNO, Pipes[1], int(BytesReq), PyD3XX.NULL)
        
        arr = np.frombuffer(ReadBuffer.Value(), np.uint16)
        
        rows = arr.shape[0] // 4
        if rows * 4 != arr.shape[0]:
            rows -= 1
            
        arr = arr[0:rows * 4].reshape(rows, 4)
        
        return arr    

    def readstream(self, startaddr: int, numaddr: int):
        self.write(512+105, int(startaddr) & 0xFFFF)
        self.write(512+106, int(startaddr) >> 16)
        self.write(512+104, 39293) # hsusb reset trigger so that next transfer starts from "startaddr"; also resets the fifo_crc
        
        # always load multiples of 512 addresses bc this is the minimum that HSUSB.vhd will handle!
        #print("numaddr: %d" % numaddr)
        if (int(numaddr) & 0x1FF)>0:
            numaddr = numaddr & 0xFFFFFFFFFFFFFE00
            numaddr = numaddr + 512
            
        data = self.readstream_raw(numaddr)
        return data

    # Stream transfer; requires firmware > 1.0.8.0
    def readsdram(self, startaddr: int, numaddr: int, normalization=-1):
        
        buffer_bytes = 2**23
        buffer_addr = buffer_bytes/8
        
        addrtransferred = 0
        curaddr = startaddr
        
        #data = np.empty((0, 4))
        data = np.empty([numaddr, 4], dtype=np.uint16)

        while addrtransferred<numaddr:
            curnumaddr = int(min(buffer_addr, numaddr-addrtransferred))
            
            #res = self.readstream(curaddr, curnumaddr)
            #data = np.concatenate((data, res[:int(curnumaddr),:]), axis=0)

            data[curaddr:(curaddr + curnumaddr), :] = self.readstream(curaddr, curnumaddr) # as uint16
            
            curaddr = curaddr + curnumaddr
            addrtransferred = addrtransferred + curnumaddr
        
        dout0 = data[0:,0]

        if normalization==0:
            dout1 = data[0:,1] ^ 2**15
            dout2 = data[0:,2] ^ 2**15
            dout3 = data[0:,3] ^ 2**15
            dout1 = dout1.astype(np.int16)
            dout2 = dout2.astype(np.int16)
            dout3 = dout3.astype(np.int16)
            
        elif normalization==1:
            dout1 = data[0:,1] ^ 2**15
            dout2 = data[0:,2] ^ 2**15
            dout3 = data[0:,3] ^ 2**15
            dout1 = dout1.astype(np.int16).astype(np.float32)/2**15
            dout2 = dout2.astype(np.int16).astype(np.float32)/2**15
            dout3 = dout3.astype(np.int16).astype(np.float32)/2**15
        else:
            dout1 = data[0:,1]
            dout2 = data[0:,2]
            dout3 = data[0:,3]

        return dout0, dout1, dout2, dout3
