classdef OSW

   properties
   
      model = "OSW"
      version = "0.9.0"
      
   end
   
   methods(Static)
   
      %%%%%%%%%%%%%%%%%%%%%%%
      % Basic communication %
      %%%%%%%%%%%%%%%%%%%%%%%

      function isConnected = init(ARG)
         % OSW.init(1);                  opens last USB device
         % OSW.init(0);                  shows list of USB devices and lets user chose one
         % OSW.init;                     same as OSW.init(1);

         if (nargin<1)
            ARG=1; % connect to last device
         end;
         
         global OSWHandle
         OSWHandle=NOVUSB('LastDevOSW.mat', ARG);
         
         isConnected = OSWHandle.isConnected;
         
      end;
      
      function close
         global OSWHandle
         OSWHandle.close
      end;
      
      % as defined by FTDI
      function [res] = setbitmode(mask, mode)
         global OSWHandle
         [res] = OSWHandle.setbitmode(mask, mode);
      end;
	  
	 
      
      %%%%%%%%%%%%%%%%%%%%%%%%%%%
      % General instrument data %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%
      
      function r = setswitch(state) % as integer number; Bit0 is first switch, Bit 2 second, and so on.
         r = OSW.setbitmode(hex2dec('F0')+2*state, hex2dec('20'));
      end
      

   end;

end