classdef NOVUSB < handle

   properties
   
      type = "USB";
      version = "1.1.1"
      Handle
      isConnected = 0

   end


   methods
   
      function obj = NOVUSB(LastDevFile, sel)
      
         % NOVUSB                : (no argument), init last device, default filename
         % NOVUSB('FileName')    : (1 string argument), init last device, custom filename
         % NOVUSB(0)             : (1 argument), show all devices, let user select one, default
         % NOVUSB('FileName', 0) : show all devices, let user select one, custom filename
         % NOVUSB('FileName', 2) : init last device, return if not found, no user input

         if (nargin<1)
            sel=1; % connect to last device
            LastDevFile = 'LastDev.mat'; 
         end;
         
         if (nargin<2)
            if (string(class(LastDevFile))=='char')
               sel=1; % connect to last device
            else
               if (LastDevFile==0)
                  sel=0;
               else
                  sel=1;
               end;
               LastDevFile = 'LastDev.mat'; 
            end;
         end;

      
         if exist(LastDevFile, 'file') && sel,
            load(LastDevFile, 'LastDevDescr',  'LastDevType');
         else
            LastDevDescr=' ';
            LastDevType=0;
         end;

         if ~exist('LastDevDescr', 'var'),
            LastDevDescr=' ';
         end;
         if ~exist('LastDevType', 'var'),
            LastDevType=0;
         end;


         while LastDevType<2 || LastDevType>3,
            LastDevType=input('Select USB2.0 (2) or USB3.0 (3) driver: ');
         end;

         switch LastDevType
            case 2
               if (sel==2) % automatic re-connection from scripts: skip user input
                  [obj.isConnected, Handle, LastDevDescr]=ft2init(LastDevDescr, 0);
               else
                  [obj.isConnected, Handle, LastDevDescr]=ft2init(LastDevDescr, 1);
               end;
            case 3
               [obj.isConnected, Handle, LastDevDescr]=ft3init(LastDevDescr);
            otherwise
         end;


         if obj.isConnected==1,
            
            obj.Handle.value = double(Handle);
            obj.Handle.type  = LastDevType;

            save(LastDevFile, 'LastDevDescr', 'LastDevType', 'Handle', '-v6');
         end;
         
         
      end;
      
     
      
      function ok=close(obj)
         switch obj.Handle.type
            case 2
               ok=ft2close(double(obj.Handle.value));
            case 3
               ok=ft3close(double(obj.Handle.value));
            otherwise
         end;
         obj.isConnected = 0;
      end;
      
      
      
      function ok = write(obj, addr, data)
      
         % pause 2 ms to force gap between commands:
         mstic=tic;
         mspause=0;
         while mspause<0.002,
            mspause=toc(mstic);
         end;

         %tic;
         if obj.Handle.value>0,
            switch obj.Handle.type
               case 2
                  ok=ft2write(double(obj.Handle.value), addr, data);
               case 3
                  ok=ft3write(double(obj.Handle.value), addr, data);
               otherwise
            end;
         else
            disp('   ---- Error: no Handle!  ----');
            ok=0;
         end;

         if ok==0,
            disp('   ---- write usb FAILED!  ----');
         end;
         %toc


      end;
      
      function ok = setbitmode(obj, mask, mode)
      
         % pause 2 ms to force gap between commands:
         mstic=tic;
         mspause=0;
         while mspause<0.002,
            mspause=toc(mstic);
         end;

         %tic;
         if obj.Handle.value>0,
            switch obj.Handle.type
               case 2
                  ok=ft2setbitmode(double(obj.Handle.value), mask, mode);
               case 3
                  disp('   ---- Error: not defined for USB3!  ----');
               otherwise
            end;
         else
            disp('   ---- Error: no Handle!  ----');
            ok=0;
         end;

         if ok==0,
            disp('   ---- setbitmode FAILED!  ----');
         end;
         %toc


      end;
      
      function [res ok] = read(obj, addr)
      
         % pause 2 ms to force gap between commands:
         %mstic=tic;
         %mspause=0;
         %while mspause<0.002,
         %   mspause=toc(mstic);
         %end;


         if obj.Handle.value>0,
            if length(addr)==1,
               switch obj.Handle.type
                  case 2
                     [ok , res]=ft2read(double(obj.Handle.value), addr);
                  case 3
                     [ok , res]=ft3read(double(obj.Handle.value), addr);
                  otherwise
               end;
            else
               res = zeros(length(addr), 1);
               for ii=1:length(addr),
                  switch obj.Handle.type
                     case 2
                        [ok , res(ii)]=ft2read(double(obj.Handle.value), addr(ii));
                     case 3
                        [ok , res(ii)]=ft3read(double(obj.Handle.value), addr(ii));
                     otherwise
                  end;
               end;
            end 
         else
            disp('   ---- Error: no Handle!  ----');
            ok=0;
         end;

         if ok==0,
            disp('   ---- read usb FAILED!  ----');
         end;
         
      end;
	  
      function [dout1 ok] = readburst(obj, rdaddr, addrstart, addrstop, wraddr)
         if obj.Handle.value>0,
            switch obj.Handle.type
               case 2
                  [ok, dout1]=ft2readburst(double(obj.Handle.value), rdaddr, addrstart, addrstop, wraddr);
               case 3
                  [ok, dout1]=ft3readburst(double(obj.Handle.value), rdaddr, addrstart, addrstop, wraddr);
               otherwise
            end;
         else
            disp('   ---- Error: no Handle!  ----');
            ok=0;
         end;
      end;
      
      
      
      % only for PM1000: Reads one block of the Poincaré sphere frame buffer
      function [res OK] = readfr(obj, BlockNr)
      
         % pause 2 ms to force gap between commands:
         mstic=tic;
         mspause=0;
         while mspause<0.002,
            mspause=toc(mstic);
         end;

         switch obj.Handle.type
            case 2
               [OK, res]=ft2readfr(double(obj.Handle.value), BlockNr);
            case 3
               %[OK, res]=ft3readfr(double(obj.Handle.value), BlockNr);
               [OK, res]=ft3readfrstream(double(obj.Handle.value), BlockNr);
               %a=2
            otherwise
         end;
          
         if OK==0,
            disp('   ---- readfrpm FAILED!  ----');
            dout=0;
         end;
      end;
	  
      function setsopstream(obj, enable)
         switch obj.Handle.type
            case 2
               if enable,
                  [OK] = ft2write(double(obj.Handle.value), 512+104, 59362);
               else
                  [OK] = ft2write(double(obj.Handle.value), 512+104, 0);
               end
               pause(0.01); % ensure the stream is stopped before purging the buffer
               [OK] = ft2purgerx(double(obj.Handle.value));;
            case 3
               if enable,
                  [OK] = ft3write(double(obj.Handle.value), 512+104, 59362);
                  [OK] = ft3setstream(obj.Handle.value,1);
               else
                  [OK] = ft3write(double(obj.Handle.value), 512+104, 0);
               end
            otherwise
         end;
         if OK==0,
            disp('   ---- ft3setstream FAILED!  ----');
            dout=0;
         end;
      end;

      function res=getsopstream(obj, norm)
         switch obj.Handle.type
            case 2
               [OK, res] = ft2getsopstream(obj.Handle.value, norm);
            case 3
               [OK, res] = ft3getsopstream(obj.Handle.value, norm);
            otherwise
         end;
         if OK==0,
            disp('   ---- ft3getstream FAILED!  ----');
            dout=0;
         end;
      end;
      
      
      
      % only for PM1000: Reads data from SDRAM
      function [res, OK, status] = readhspm(obj, addr, numaddr)
      
         usb3stream=1; % set this to "1" for PM1000 with fw>=1080
         %usb3stream=0; % set this to "1" for PM1000 with fw>=1080

         OK=0;
         
         status = 0;

         switch obj.Handle.type
            case 2
               buffer_bytes=2^16;
            case 3
               if usb3stream,
                  buffer_bytes=2^23;
               else
                  buffer_bytes=2^12;
               end;
            otherwise
         end;


         buffer_addr = buffer_bytes/8; % 64 bits per addr

         addrtransferred=0;
         curaddr = addr;

         res = [];
         

         while addrtransferred<numaddr,

            curnumaddr = min(buffer_addr, numaddr-addrtransferred);
            curdout = [];
            curstatus = 0;

            switch obj.Handle.type
               case 2
                  [OK, curdout(1,:) curdout(2,:) curdout(3,:) curdout(4,:)]=ft2readhs(obj.Handle.value, curaddr, curnumaddr);
               case 3
                  
                  if usb3stream,
                     [OK, curdout, status] = ft3readstream_crc(obj.Handle.value, curaddr, curnumaddr, 1);
                  else
                     [OK, curdout(1,:) curdout(2,:) curdout(3,:) curdout(4,:)] = ft3readhs(obj.Handle.value, curaddr, curnumaddr);
                  end;
               otherwise
            end;

            
            %toc(transferstart)
          
            if OK==0,
               disp('   ---- readpm FAILED!  ----');
               numaddr = 0; % to stop loop
            else
               %res = [res; curdout];
               res = [res curdout];
               curaddr = curaddr + curnumaddr;
               addrtransferred = addrtransferred + curnumaddr;
            end;
            
            status = status + curstatus;

           
         end;

      end
      
      
      
      





         
         

   end;

end